/////////////////////////////////////////////////////////////
// CINEMA SDK : RENDERING																	 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

// video post classes

#ifndef __C4D_VIDEOPOSTPLUGIN_H
#define __C4D_VIDEOPOSTPLUGIN_H

#include "ge_math.h"
#include "c4d_basetime.h"
#include "c4d_videopostdata.h"
#include "c4d_nodeplugin.h"

struct VolumeData;
struct VideoPostStruct;
struct RayFragment;
struct Multipass;
struct PixelFragment;
class  BaseDocument;
class  BaseThread;
class  BaseDraw;
class  BaseDrawHelp;
class  HyperFile;
class  Render;
class  BaseContainer;
class  CDialog;

struct BaseVideoPostStruct
{
	// C4D version number
	LONG					version;	

	// VP_xxx type
	LONG					vp;

	// TRUE if it is an opener, FALSE if it is a closer
	Bool					open;

	// current time
	BaseTime			time;			

	// render frame rate (this may be different to doc->GetFps())
	LONG					fps;      

	// pointer to LONG containing RAY_xxx states
	LONG					*error;

	// pointer to VolumeData; may be NULL
	VolumeData		*vd;	

	// document
	BaseDocument	*doc;

	// thread; use thread->TestBreak() to check for a user break
	BaseThread		*thread;

	// current subframe and number of subframes
	LONG					subframe,subframe_cnt;

	// current field and number of fields
	LONG					field,field_cnt;

	// rendering in editor
	Bool					editor_render;

	// render instance
	Render				*render;
};

#define VP_FRAMESEQUENCE	1 // called when the renderer prepares to render a sequence of images
#define VP_FRAME					2 // called when the renderer prepares to render a frame
#define VP_SUBFRAME				3 // called when the renderer prepares to render a subframe
#define VP_RENDER					4 // called before the rendering process starts and before shaders are initialized
#define VP_INNER					5 // called immediately before rendering starts

// common buffers
#define VPBUFFER_RGBA								 1 
#define VPBUFFER_AMBIENT						 2 
#define VPBUFFER_DIFFUSE						 3 
#define VPBUFFER_SPECULAR						 4 
#define VPBUFFER_SHADOW							 5 
#define VPBUFFER_REFLECTION					 6
#define VPBUFFER_TRANSPARENCY				 7
#define VPBUFFER_RADIOSITY					 8
#define VPBUFFER_CAUSTICS						 9
#define VPBUFFER_ATMOSPHERE					10
#define VPBUFFER_ATMOSPHERE_MUL			11
#define VPBUFFER_ALLPOSTEFFECTS			12

#define VPBUFFER_IMAGEBUILDING_PASS	32

// special buffers
#define VPBUFFER_DEPTH							100
#define VPBUFFER_MAT_COLOR					101
#define VPBUFFER_MAT_DIFFUSION			102
#define VPBUFFER_MAT_LUMINANCE			103
#define VPBUFFER_MAT_TRANSPARENCY		104
#define VPBUFFER_MAT_REFLECTION			105
#define VPBUFFER_MAT_ENVIRONMENT		106
#define VPBUFFER_MAT_SPECULAR				107
#define VPBUFFER_MAT_SPECULARCOLOR	108
#define VPBUFFER_ILLUMINATION				109
#define VPBUFFER_OBJECTBUFFER				110

#define VPBUFFER_POSTEFFECT					111
#define VPBUFFER_POSTEFFECT_MUL			112

#define VPBUFFER_BLEND						 1000
#define VPBUFFER_LIGHTBLEND				 1001 // private ID
#define VPBUFFER_ALPHA             1002 // for sdk request only 

struct PixelPost
{
#ifdef __API_INTERN__
	RayFragment **frag;
#else
	PixelFragment **frag;
#endif
	VolumeData	*vd;
	Real				*col;
	Multipass		*mp;
	Bool				aa,valid_line;
	LONG				comp;
	LONG				cpu_num;
	LONG				left,right,line;
};

#define VPlenseffects								  1001049
#define VPobjectglow									1001007
#define VPcolorcorrection							1001008
#define VPcomic												1001009
#define VPscenemotionblur							1001010
#define VPobjectmotionblur						1001011
#define VPsoftfilter									1001012
#define VPsharpenfilter								1001013
#define VPmedianfilter								1001014
#define VPremote											1001015
#define VPopticsuite_depthoffield		  1001400
#define VPopticsuite_glow						  1001401
#define VPopticsuite_highlights			  1001402

#define VPPRIORITY_OBJECTGLOW						 500
#define VPPRIORITY_OBJECTMOTIONBLUR			 400
#define VPPRIORITY_DEPTHOFFIELD					 300
#define VPPRIORITY_LENSEFFECTS					 200
#define VPPRIORITY_FILTERSOFT						 100
#define VPPRIORITY_FILTERSHARPEN				 100
#define VPPRIORITY_FILTERMEDIAN					 100

#define VPPRIORITY_COMIC								 600
#define VPPRIORITY_COLORCORRECTION			 500
#define VPPRIORITY_SCENEMOTIONBLUR			 100
#define VPPRIORITY_EXTERNAL							 100

// info flags
#define PLUGINFLAG_VIDEOPOST_MULTIPLE			(1<<0)	// allow multiple effects of this type
#define PLUGINFLAG_VIDEOPOST_INHERENT			(1<<1)  // VP always is present
																					
// GetRenderInfo flags										
#define VIDEOPOST_STOREFRAGMENTS					(1<<0)  // VP needs fragment information for whole image at VP_INNER/VP_RENDER
#define VIDEOPOST_RAYTRACING							(1<<1)	// VP needs raytracing
#define VIDEOPOST_REFRESH									(1<<2)	// external update screen
#define VIDEOPOST_EXECUTELINE							(1<<4)	// line overload
#define VIDEOPOST_EXECUTEPIXEL						(1<<5)	// pixel overload
#define VIDEOPOST_REQUEST_MOTIONMATRIX		(1<<6)  
#define VIDEOPOST_REQUEST_MOTIONGEOMETRY	(1<<7)
																					
#define VPGETFRAGMENTS_Z_P								(1<<0)	
#define VPGETFRAGMENTS_N									(1<<1)

struct VIDEOPOSTPLUGIN : public NODEPLUGIN
{
	LONG	priority;

	Bool	(VideoPostData::*Draw						)(PluginVideoPost *node, BaseDraw *bd, BaseDrawHelp *bh);
	void	(VideoPostData::*AllocateBuffers)(PluginVideoPost *node, Render *render, BaseDocument *doc);
	LONG	(VideoPostData::*GetRenderInfo  )(PluginVideoPost *node);

	LONG	(VideoPostData::*Execute				)(PluginVideoPost *node, VideoPostStruct *vps);
	void	(VideoPostData::*ExecuteLine		)(PluginVideoPost *node, PixelPost *pp);
	void	(VideoPostData::*ExecutePixel   )(PluginVideoPost *node, PixelPost *pp, LONG x, LONG subx, LONG suby);

	void*	reserved[(32-6)*C4DPL_MEMBERMULTIPLIER-1];
};

#endif
